#include <msp430x14x.h>
typedef unsigned char uchar;
typedef unsigned int  uint;

#define SCL_H P1OUT |= BIT2
#define SCL_L P1OUT &= ~BIT2
#define SDA_H P1OUT |= BIT3
#define SDA_L P1OUT &= ~BIT3

#define SDA_in  P1DIR &= ~BIT3   //SDAĳģʽ
#define SDA_out P1DIR |= BIT3    //SDAģʽ
#define SDA_val P1IN&BIT3        //SDAλֵ
 
#define TRUE    1
#define FALSE   0

/*******************************************
ƣdelay
    ܣʱԼ15usʱ
    
ֵ  
********************************************/
void delay(void)
{
    uchar i;
    
	for(i = 0;i < 15;i++)
	  _NOP();
}	
/*******************************************
ƣstart
    ܣIICʼ
    
ֵ  
********************************************/
void start(void)
{
	SCL_H;
	SDA_H;
	delay();
	SDA_L;
	delay();
	SCL_L;
	delay();
}
/*******************************************
ƣstop
    ܣIICֹ
    
ֵ  
********************************************/
void stop(void)
{
	SDA_L;
	delay();
	SCL_H;
	delay();
	SDA_H;
	delay();	   
}
/*******************************************
ƣmack
    ܣIICӦ
    
ֵ  
********************************************/
void mack(void)
{
	SDA_L;
	_NOP(); _NOP();
	SCL_H;
	delay();
	SCL_L;
	_NOP();_NOP();
	SDA_H;     
	delay();
}
/*******************************************
ƣmnack
    ܣIICӦ
    
ֵ  
********************************************/
void mnack(void)
{
	SDA_H;
	_NOP(); _NOP();
	SCL_H;
	delay();
	SCL_L;
	_NOP(); _NOP();
	SDA_L;   
	delay();       
}

/**********Ӧźź******************/
/*ֵΪ1֤Ӧźţ֮û*/
/*******************************************
ƣcheck
    ܣӻӦ
    
ֵ  ӻǷӦ1--У0--
********************************************/
uchar check(void)
{
	uchar slaveack;
    
	SDA_H;
	_NOP(); _NOP();
	SCL_H;
	_NOP(); _NOP();
        SDA_in;
        _NOP(); _NOP();
	slaveack = SDA_val;   //SDAֵ
	SCL_L;
	delay();
    SDA_out;
    if(slaveack)    return FALSE;
    else            return TRUE;
}
/*******************************************
ƣwrite1
    ܣIIC߷һ1
    
ֵ  
********************************************/
void write1(void)
{
	SDA_H;
	delay();
	SCL_H;
	delay();
	SCL_L;				
	delay();
}
/*******************************************
ƣwrite0
    ܣIIC߷һ0
    
ֵ  
********************************************/
void write0(void)
{
	SDA_L;
	delay();
	SCL_H;
	delay();			 
	SCL_L;				
	delay();
}
/*******************************************
ƣwrite1byte
    ܣIIC߷һֽڵ
    wdata--͵
ֵ  
********************************************/
void write1byte(uchar wdata)
{
	uchar i;
    
	for(i = 8;i > 0;i--)
	{
		if(wdata & 0x80)	write1();
		else 			    write0();
		wdata <<= 1;
	}                  
	
	SDA_H;
	_NOP();   
}
/*******************************************
ƣwriteNbyte
    ܣIIC߷Nֽڵ
    outbuffer--ָݴ׵ַ
          ָ
          n--ݵĸ
ֵ  Ƿɹı־1--ɹ0--ʧ
********************************************/
uchar writeNbyte(uchar * outbuffer,uchar n)
{
	uchar i;
    
	for(i = 0;i < n;i++)
	{
		write1byte(* outbuffer);
		if(check())      
		{
			outbuffer++;			
		}
		else 
		{
			stop();
			return FALSE;
		}
	}

	stop();
	return TRUE;			
}
/*******************************************
ƣread1byte
    ܣIIC߶ȡһֽ
    
ֵ  ȡ
********************************************/
uchar read1byte(void)
{
	uchar  rdata = 0x00,i;
    uchar flag;
    
	for(i = 0;i < 8;i++)
	{
		SDA_H;
		delay();
		SCL_H;
        SDA_in;
		delay();
		flag = SDA_val;
		rdata <<= 1;
		if(flag)	rdata |= 0x01;
        SDA_out;
		SCL_L;
		delay();
	}

	return rdata;
}
/*******************************************
ƣreadNbyte
    ܣIIC߶ȡNֽڵ
    inbuffer--ȡݴŵ׵ַ
          n--ݵĸ
ֵ  
********************************************/
void readNbyte(uchar * inbuffer,uchar n)
{
	uchar i;
    
	for(i = 0;i < n;i++)
	{
		inbuffer[i] = read1byte();
		if(i < (n-1))	mack();
		else            mnack();
	}
	 
	stop();
}
