#include "IIC.h"
typedef unsigned char uchar;
typedef unsigned int  uint;

#define deviceaddress 0xa0  //AT24C02豸ַ

/*******************************************
ƣdelay_10ms
    ܣʱԼ6msȴEEPROMڲд
    
ֵ  
********************************************/
void delay_10ms(void)
{
	uint i = 1000;
	while(i--);
}
/*******************************************
ƣWrite_1Byte
    ܣEEPROMд1ֽڵ
    Wdata--д
          dataaddress--ݵдַ
ֵ  д1--ɹ0--ʧ
********************************************/
uchar Write_1Byte(uchar wdata,uchar dataaddress)
{
	start();
	write1byte(deviceaddress);
	if(check()) 
        write1byte(dataaddress);
	else 
        return 0;
	if(check()) 
        write1byte(wdata);
	else 
        return 0;
	if(check())	    stop();
	else            return 0;
    
    delay_10ms();       //ȴEEPROMڲд
	return 1; 
}
/*******************************************
ƣWrite_NByte
    ܣEEPROMдNֽڵ
    outbuf--ָдݴ׵ַָ
          n--ݸܳ8ҳַ
             󳤶
          dataaddress--д׵ַ
ֵ  д1--ɹ0--ʧ
********************************************/
uchar Write_NByte(uchar * outbuf,uchar n,uchar dataaddress)
{
	uchar  flag; 
    
	start();
	write1byte(deviceaddress);                  //дַ
	if(check() == 1) 
        write1byte(dataaddress);                //дֵַ
	else 
        return 0;
	if(check()) 
        flag=writeNbyte(outbuf,n);
	else 
        return 0;
    delay_10ms();       //ȴEEPROMڲд
	if(flag)    return 1;
	else        return 0;

}
/*******************************************
ƣRead_1Byte_currentaddress
    ܣEEPROMĵǰַȡ1ֽڵ
    
ֵ  ȡ
********************************************/
uchar Read_1Byte_currentaddress(void)
{
	uchar temp;
    
	start();
	write1byte((deviceaddress|0x01));
	if(check())	
        temp = read1byte();
	else 
        return 0;
	mnack();
	stop();
	return temp;
}
/*******************************************
ƣRead_NByte_currentaddress
    ܣEEPROMĵǰַȡNֽڵ
    readbuf--ָ򱣴ݵַָ
          n--ȡݵĸ
ֵ  ȡ1--ɹ0--ʧ
********************************************/
uchar Read_NByte_currentaddress(uchar * readbuf,uchar n)
{   
    start();
	write1byte((deviceaddress|0x01));
	if(check()) 
        readNbyte(readbuf,n);
	else 
        return 0;
    
	return  1;
}

/*******************************************
ƣRead_1Byte_Randomaddress
    ܣEEPROMַָȡ1ֽڵ
    dataaddress--ݶȡĵַ
ֵ  ȡ
********************************************/
uchar Read_1Byte_Randomaddress(uchar dataaddress)
{
	uchar temp;
    
	start();
	write1byte(deviceaddress);
	if(check())	
        write1byte(dataaddress);
	else 
        return 0;
	if(check()) 
	{
		start();
		write1byte((deviceaddress|0x01));
	}
	else    
        return 0;
	if(check())	
        temp = read1byte();
	else 
        return 0;

	mnack();
	stop();
	return temp;
}
/*******************************************
ƣRead_NByte_Randomaddress
    ܣEEPROMַָȡNֽڵ
    readbuf--ָ򱣴ݵַָ
          n--ȡݵĸ
          dataaddress--ݶȡ׵ַ
ֵ  ȡ1--ɹ0--ʧ
********************************************/
uchar Read_NByte_Randomaddress(uchar * readbuf,uchar n,uchar dataaddress)
{
	start();
	write1byte(deviceaddress);
	if(check())	
        write1byte(dataaddress);
	else 
        return 0;
	if(check()) 
	{
		start();
		write1byte(deviceaddress|0x01);
	}
	else 
        return 0;
	if(check()) 
        readNbyte(readbuf,n);
	else 
        return 0;
	
	return 1;	
}
